*** Do-file til kapittel 7
use "https://nedlasting.fagbokforlaget.no/stata/ESS7NO_Helse2.dta", clear
************************
*** Trinn 1 Beskrive de 8 indikatorene
***********
codebook fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng, compact
tab1 fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng
* snu tallkodene på to spørsmål og sjekke at omkoding er korrekt.
gen wrhpp_r = 5 - wrhpp
gen enjlf_r = 5 - enjlf
tab1 wrhpp_r wrhpp enjlf_r enjlf
*** Lage en sumvariabel for antall manglende svar for hver respondent 
egen cesd_miss = rowmiss(fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng)
tabu cesd_miss
********************
* Trinn 2 Eksplorerende faktoranalyse
**********
* Beskrivende statistikk og korrelasjonsmatrise
codebook fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng, compact
tab1 fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng
summ fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng
gen wrhpp_r = 5 - wrhpp
gen enjlf_r = 5 - enjlf
tab1 wrhpp_r wrhpp enjlf_r enjlf 
egen float cesd_miss = rowmiss(fltdpr flteeff slprl wrhpp_r fltlnl ///
  enjlf_r fltsd cldgng) /* teller antall missing */
tabu  cesd_miss
global ylist fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng
corr $ylist
*** PCA på CS-D 8 items, NB, ikke Stata-pca, men Stata factor, pcf.  
set more off
factor $ylist, pcf
screeplot
loadingplot
estat kmo
rotate, blanks(.3)
rotate, promax blanks(.3)
**** Enfaktor-løsning
factor $ylist, factors (1)pcf
********************************
* Trinn 3 Reliabilitetsanalyse
********
alpha fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng, ///
      casewise item reverse(wrhpp enjlf)
alpha $ylist, item s   /* Alpha med standardioserte items */
*****************************
* Trinn 4 Konstruere skalen for depresjon
***********
egen float cesd8 = rowmean(fltdpr flteeff slprl wrhpp_r fltlnl /// 
  enjlf_r fltsd cldgng) if cesd_miss < 3   /* skala 8 items */
**** Skala med 5 items  
egen cesd5_miss = rowmiss(fltdpr flteeff fltlnl fltsd cldgng)
tabu cesd5_miss
egen float cesd5ny = rowmean(fltdpr flteeff fltlnl fltsd cldgng) /// 
if cesd5_miss < 2
histogram cesd8, bin(23) percent  /* fordelingens form */
***************************
* Trinn 5  Vurdering av begrepsvaliditet
************
corr cesd8 cesd5 happy kvinne utdniv
********************
** SEM
**********
** Grunnmodell med en faktor
sem (CESD -> fltdpr, ) (CESD -> flteeff, ) (CESD -> slprl, ) /// 
    (CESD -> wrhpp_r, ) (CESD -> fltlnl, ) (CESD -> enjlf_r, ) ///
	(CESD -> fltsd, ) (CESD -> cldgng, ), standardized latent(CESD ) nocapslatent
estat gof, stats(all)
estat mindices
* Forenklet syntaks
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r ///
 fltsd cldgng), standardized
estat gof, stats(all)
estat mindices
*** Grunnmodell med en faktor   + kovarians mellom e4 og e6.
sem (CESD -> fltdpr, ) (CESD -> flteeff, ) (CESD -> slprl, ) (CESD -> wrhpp_r, ) ///
    (CESD -> fltlnl, ) (CESD -> enjlf_r, ) (CESD -> fltsd, ) (CESD -> cldgng, ), ///
	 standardized latent(CESD ) cov( e.wrhpp_r*e.enjlf_r) nocapslatent
estat gof, stats(all)
*** Forenklet syntaks
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng), ///
     standardized cov( e.wrhpp_r*e.enjlf_r)
estat gof, stats(all)
*** + cov( e.flteeff*e.cldgng)
sem (CESD -> fltdpr, ) (CESD -> flteeff, ) (CESD -> slprl, ) /// 
    (CESD -> wrhpp_r, ) (CESD -> fltlnl, ) (CESD -> enjlf_r, ) /// 
	(CESD -> fltsd, ) (CESD -> cldgng, ), standardized latent(CESD ) /// 
	 cov(e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r) nocapslatent
estat gof, stats(all)
* Forenklet syntaks
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng), ///
     cov(e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r)
estat gof, stats(all)
* vce(sbentler)  ikke benyttet
*********************
*** Tofaktormodell
sem (L1 -> fltdpr, ) (L1 -> flteeff, ) (L1 -> slprl, ) (L1 -> fltsd, ) ///
    (L1 -> cldgng, ) (L2 -> wrhpp, ) (L2 -> fltlnl, ) (L2 -> enjlf, ), ///
	covstruct(_lexogenous, diagonal) standardized latent(L1 L2 ) cov( L2*L1) nocapslatent
estat gof, stats(all)
estat mindices
** Forenklet syntaks
sem (L1 -> fltdpr flteeff slprl fltsd cldgng)(L2 -> wrhpp_r fltlnl enjlf_r )
estat gof, stats(all)
estat mindices
*** + + cov( e.flteeff*e.cldgng)
sem (L1 -> fltdpr, ) (L1 -> flteeff, ) (L1 -> slprl, ) (L1 -> fltsd, ) ///
    (L1 -> cldgng, ) (L2 -> wrhpp, ) (L2 -> fltlnl, ) (L2 -> enjlf, ), ///
	covstruct(_lexogenous, diagonal) standardized latent(L1 L2 ) ///
	cov( L2*L1 e.flteeff*e.cldgng) nocapslatent
estat gof, stats(all)
****************************
* Kriterierelateret validitet
*********
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng) ///
   (kvinne -> CESD, ) (utdniv -> CESD, ), standardized ///
    cov( e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r kvinne*utdniv) 
estat gof, stats(all)
***************************************
**** Teste målingsinvarians
****************
** Først estimeres modellen for gruppene uten å sette likheter
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng), ///  
     cov(e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r) group(kvinne) ///
     ginvariant(none) means(CESD@0)   /* Setter CESD-snitt til 0 */ 
estat gof, stats(all)
estat ginvariant    /* Wald test */
***********
* Modell sterk1 målekoeffisienter og konstanter er like (sterk invarians)
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng), ///  
     cov(e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r) group(kvinne) ///
     ginvariant(mcoef mcons) means(CESD@0)   /* Setter CESD-snitt til 0 */ 
estat ginvariant, showpclass(mcoef mcons)   /* score test */
estat gof, stats(all)
estimates store sterk1
* Ulike mcoeff: fltdpr, fltlnl; ulike mcons: flteeff, slprl
***********
* Modell sterk2: delvis sterk invarians
************
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng) ///  
 (0: fltlnl<-CESD@b02) (1: fltlnl<-CESD@b12) /// Fri koef 
 (0: flteeff<-CESD _cons@a01) (1: flteeff<-CESD _cons@a11) /// Fri konstant
 (0: slprl<-CESD _cons@a02) (1: slprl<-CESD _cons@a12), ///  Fri konstant
  cov(e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r)  ///   
  group(kvinne) ///  Definerer gruppevariabel
  ginvariant(mcoef mcons ) ///  Like målekoeffisienter og konstanter
  means(CESD@0)   
estat gof, stats(all)
estat ginvariant, showpclass(mcoef mcons)   /* score test */
estimates store sterk2
lrtest sterk1 sterk2
******************
******* Modell sterk2 modifisert slik at gruppegjennomsnitt estimeres
* (ikke benyttet i boka)
sem (CESD -> fltdpr flteeff slprl wrhpp_r fltlnl enjlf_r fltsd cldgng) ///  
 (0: fltlnl<-CESD@b02) (1: fltlnl<-CESD@b12) /// Fri koef 
 (0: flteeff<-CESD _cons@a01) (1: flteeff<-CESD _cons@a11) /// Fri konstant
 (0: slprl<-CESD _cons@a02) (1: slprl<-CESD _cons@a12), ///  Fri konstant
  cov(e.flteeff*e.cldgng e.wrhpp_r*e.enjlf_r)  ///   
  group(kvinne) ///  Definerer gruppevariabel
  ginvariant(mcoef mcons)  
estat gof, stats(all)
	 

	 
	 

	 